<?php
/**
 * File containing the eZ Publish view implementation.
 *
 * @copyright Your Name here
 * @license licence details
 * @version 1.0.0
 * @package mynewsletter
 */


function ezUpdate42( $contentObject ) /* adapted from updateAndPublishObject in version 4.3 */
{
    $db = eZDB::instance();
    $db->begin();
    $newVersion = $contentObject->createNewVersion( false, true, $languageCode );

    if ( !$newVersion instanceof eZContentObjectVersion )
    {
        eZDebug::writeError( 'Unable to create a new version for object ' . $contentObject->attribute( 'id' ),
                             'userlist.php' );
        $db->rollback();
        return false;
    }

    $newVersion->setAttribute( 'modified', time() );
    $newVersion->store();

    $attributeList = $newVersion->attribute( 'data_map' );
    $newsletter_attribute = $attributeList['$attributeList'];
    $newsletter_attribute->fromString( 0 );
    $newsletter_attribute->store();

    $db->commit();

    $operationResult = eZOperationHandler::execute( 'content', 'publish', array( 'object_id' => $newVersion->attribute( 'contentobject_id' ),
                                                                                 'version'   => $newVersion->attribute( 'version' ) ) );
    return $operationResult;
}

$tpl = eZTemplate::factory(); //this line of code is for ez publish 4.3, replace it with the following line for versions prior to that
// $tpl = templateInit(); //version <4.3 of eZ Publish should use this line of code instead



if ( isset( $Params['remove'] ) )
{
    $result = 0; //used to measure whether the update has been made successfully or not

    $contentObject = eZContentObject::fetch( $Params['remove'] );

    if( $contentObject instanceof eZContentObject )
    {
        /* code for eZ Publish 4.3 onwards */
        $params = array();
        $attributes = array( "newsletter" => 0 );
        $params['attributes'] = $attributes;
        $result = eZContentFunctions::updateAndPublishObject( $contentObject, $params );

        /* code for eZ Publish 4.2 and earlier - see additional function for full code */
        // $result = ezUpdate42($contentObject);
    }
    if ( $result==0 )
    {
        $tpl->setVariable( 'error', "There was a problem updating the user" );
    }
    else
    {
        $tpl->setVariable( 'feedback', "The user has been removed successfully" );
    }
}


// Process template and set path data:
$Result = array();
$Result['content'] = $tpl->fetch( 'design:newsletter/userlist.tpl' ); //main tpl file to display the output
$Result['left_menu'] = "design:newsletter/leftmenu.tpl";
$Result['path'] = array( array( 'url'  => 'newsletter/userlist',
                                'text' => 'User List' ) );
?>