{def $users_folder     = fetch( 'content', 'node', hash( 'node_path', 'Users/Members' ) )
	 $newsletter_users = fetch( 'content', 'list', hash( 'parent_node_id', $users_folder.node_id,
                                                         'attribute_filter', array( array( 'user/newsletter', '=' , 1 ) ) ) )
	 $module_details   = module_params()
}


{* Include message box if necessary: *}
{if or( is_set( $feedback ), is_set( $error ) )}
	{include uri="design:newsletter/newsletter_feedback_box.tpl" feedback=$feedback error=$error}
{/if}


<div class="box-header">
    <div class="button-left">
    	<h2 class="context-title">{'Newsletter Users'|i18n( 'mynewsletter/design' )} ({$newsletter_users|count()})</h2>
    </div>
	<div class="float-break"></div>
</div>

<div class="box-content">    
	<div class="content-navigation-childlist">
	    <table cellspacing="0" class="list" id="ezasi-subitems-list">
		    <thead>
			    <tr>
			        <th>{'Name'|i18n( 'mynewsletter/design' )}</th>
			        <th>{'Email'|i18n( 'mynewsletter/design' )}</th>
			        <th></th>
			    </tr>
		    </thead>
		    <tbody>
				{for 0 to $newsletter_users|count()|dec() as $counter}
			        <tr class="{if eq( $counter|mod(2), 0 )}bglight{else}bgdark{/if}">
				        <td>{$newsletter_users[$counter].name|wash()}</td>
				        <td>{$newsletter_users[$counter].data_map.user_account.content.email|wash()}</td>
				        <td>
				        	<a href={concat( $module_details['module_name'], '/', $module_details['function_name'], '/remove/', $newsletter_users[$counter].contentobject_id )|ezurl()}>
				        		{'Remove from list'|i18n( 'mynewsletter/design' )}
				        	</a>
				        </td>
					</tr>
			  	{/for}
			</tbody>
		</table>
	</div>
</div>
{undef}


