/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.request.ClassPrepareRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import jde.debugger.Debug;
import jde.debugger.EventHandler;
import jde.debugger.GeneralCommands;
import jde.debugger.JDEException;
import jde.debugger.Jdebug;
import jde.debugger.LispForm;
import jde.debugger.ObjectStore;
import jde.debugger.Protocol;
import jde.debugger.SpecCommands;
import jde.debugger.ThreadCommands;
import jde.debugger.spec.BreakpointSpec;
import jde.debugger.spec.EventRequestSpec;
import jde.debugger.spec.EventRequestSpecList;
import jde.debugger.spec.ExceptionSpec;
import jde.debugger.spec.WatchpointSpec;

public class Application
implements Protocol {
    final Integer appID;
    final Jdebug jdebug;
    Socket sioSocket = null;
    EventHandler eventHandler;
    VirtualMachine vm;
    EventRequestSpecList eventRequestSpecs;
    Collection pendingCommands;
    ObjectStore store;
    private long objIdCounter = 0L;
    GeneralCommands generalCommands;
    SpecCommands specCommands;
    ThreadCommands threadCommands;
    private boolean shuttingDown = false;
    Thread standardIOConnectThread;
    StandardInputProcessor standardInputProcessor;
    StandardOutputProcessor standardOutputProcessor;
    StandardErrorProcessor standardErrorProcessor;
    StandardOutputWriter standardOutputWriter;

    public Application(Jdebug jdebug, Integer appID, VirtualMachine vm) {
        this.jdebug = jdebug;
        this.appID = appID;
        this.vm = vm;
        this.pendingCommands = Collections.synchronizedSet(new HashSet());
        this.store = new ObjectStore(this);
        this.eventHandler = new EventHandler(this);
        this.eventRequestSpecs = new EventRequestSpecList(this);
        ClassPrepareRequest cprequest = vm.eventRequestManager().createClassPrepareRequest();
        cprequest.putProperty("default", "default");
        cprequest.setSuspendPolicy(2);
        cprequest.enable();
        this.generalCommands = new GeneralCommands(this, this.store);
        this.specCommands = new SpecCommands(this, this.eventRequestSpecs, this.store);
        this.threadCommands = new ThreadCommands(this, this.store);
    }

    public final VirtualMachine getVM() {
        return this.vm;
    }

    public final Integer getId() {
        return this.appID;
    }

    public final Long generateObjectID() {
        Integer n = Jdebug.debuggerID;
        synchronized (n) {
            Long l = new Long(this.objIdCounter++);
            return l;
        }
    }

    public final ObjectStore getStore() {
        return this.store;
    }

    public final EventQueue getEventQueue() {
        return this.vm.eventQueue();
    }

    public final void shutdown() {
        this.shuttingDown = true;
        Process process = null;
        if (this.vm != null) {
            process = this.vm.process();
        }
        try {
            try {
                if (this.vm != null) {
                    this.vm.dispose();
                    this.vm = null;
                    this.eventHandler.shutdown();
                }
                this.sioSocket.close();
            }
            catch (Exception ex) {
                Object var4_3 = null;
                if (process != null) {
                    process.destroy();
                }
                this.jdebug.removeApplication(this.appID);
            }
            Object var4_2 = null;
            if (process != null) {
                process.destroy();
            }
            this.jdebug.removeApplication(this.appID);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (process != null) {
                process.destroy();
            }
            this.jdebug.removeApplication(this.appID);
            throw throwable;
        }
    }

    public int initSIOConnect() throws JDEException {
        ServerSocket ss = null;
        try {
            ss = new ServerSocket(0);
        }
        catch (IOException ex) {
            throw new JDEException("Unable to create a server socket");
        }
        final ServerSocket sstmp = ss;
        final int port = ss.getLocalPort();
        this.standardIOConnectThread = new Thread("Standard I/O Thread for App #" + this.appID){

            public void run() {
                try {
                    Application.this.signal("message", "Debugger waiting for Emacs to connect to app SIO port " + port + ".");
                    Application.this.sioSocket = sstmp.accept();
                    sstmp.close();
                }
                catch (IOException ex) {
                    Application.this.signal("error", "IOException occurred while connecting to app SIO port " + port + ". Shutting down...");
                    Application.this.shutdown();
                }
            }
        };
        this.standardIOConnectThread.start();
        return port;
    }

    public void initSIOTransport() {
        try {
            this.standardIOConnectThread.join();
            this.signal("message", "Debugger connected to standard I/O socket.");
            Process process = this.vm.process();
            this.standardInputProcessor = new StandardInputProcessor(process.getOutputStream());
            this.standardInputProcessor.start();
            this.standardOutputWriter = new StandardOutputWriter(this.sioSocket);
            this.standardOutputProcessor = new StandardOutputProcessor(process.getInputStream());
            this.standardOutputProcessor.start();
            this.standardErrorProcessor = new StandardErrorProcessor(process.getErrorStream());
            this.standardErrorProcessor.start();
        }
        catch (InterruptedException ex1) {
            this.signal("error", "Debugger interrupted while waiting for Emacs to connect to standard I/O socket.");
        }
    }

    public List findClassesMatchingPattern(String pattern) throws JDEException {
        if (this.vm == null) {
            return null;
        }
        ArrayList<ReferenceType> result = new ArrayList<ReferenceType>();
        if (pattern.startsWith("*.")) {
            pattern = pattern.substring(1);
            List<ReferenceType> classes = this.vm.allClasses();
            Iterator<ReferenceType> iter = classes.iterator();
            while (iter.hasNext()) {
                ReferenceType type = iter.next();
                if (!type.name().endsWith(pattern)) continue;
                result.add(type);
            }
            return result;
        }
        return this.vm.classesByName(pattern);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleCommand(Integer cmd_id, String command, List args) {
        Collection collection;
        Collection collection2 = this.pendingCommands;
        synchronized (collection2) {
            if (this.pendingCommands.contains(cmd_id)) {
                this.signalCommandError(new Integer(-1), "Duplicate command id '" + cmd_id + "'");
            }
        }
        try {
            try {
                command = command.toLowerCase();
                if (command.equals("finish")) {
                    this.generalCommands.doFinish(cmd_id, args);
                }
                if (command.equals("get_object")) {
                    this.generalCommands.doGetObject(cmd_id, args);
                }
                if (command.equals("get_loaded_classes")) {
                    this.generalCommands.doGetLoadedClasses(cmd_id, args);
                }
                if (command.equals("get_path_information")) {
                    this.generalCommands.doGetPathInformation(cmd_id, args);
                }
                if (command.equals("trace_classes")) {
                    this.generalCommands.doTraceClasses(cmd_id, args);
                }
                if (command.equals("cancel_trace_classes")) {
                    this.generalCommands.doCancelTraceClasses(cmd_id, args);
                }
                if (command.equals("trace_exceptions")) {
                    this.specCommands.doTraceExceptions(cmd_id, args);
                }
                if (command.equals("watch")) {
                    this.specCommands.doWatch(cmd_id, args);
                }
                if (command.equals("break")) {
                    this.specCommands.doBreak(cmd_id, args);
                }
                if (command.equals("clear")) {
                    this.specCommands.doClear(cmd_id, args);
                }
                if (command.equals("step")) {
                    this.specCommands.doStep(cmd_id, args);
                }
                if (command.equals("trace_methods")) {
                    this.generalCommands.doTraceMethods(cmd_id, args);
                }
                if (command.equals("cancel_trace_methods")) {
                    this.generalCommands.doCancelTraceMethods(cmd_id, args);
                }
                if (command.equals("suspend")) {
                    this.threadCommands.doSuspend(cmd_id, args);
                }
                if (command.equals("resume")) {
                    this.threadCommands.doResume(cmd_id, args);
                }
                if (command.equals("interrupt")) {
                    this.threadCommands.doInterrupt(cmd_id, args);
                }
                if (command.equals("kill_thread")) {
                    this.threadCommands.doKillThread(cmd_id, args);
                }
                if (command.equals("get_threads")) {
                    this.threadCommands.doGetThreads(cmd_id, args);
                }
                if (command.equals("get_thread")) {
                    this.threadCommands.doGetThread(cmd_id, args);
                }
                if (command.equals("get_object_monitors")) {
                    this.threadCommands.doGetObjectMonitors(cmd_id, args);
                }
                if (command.equals("trace_threads")) {
                    this.threadCommands.doTraceThreads(cmd_id, args);
                }
                if (command.equals("cancel_trace_threads")) {
                    this.threadCommands.doCancelTraceThreads(cmd_id, args);
                }
                this.signalCommandError(cmd_id, "'" + command + "' is not supported");
            }
            catch (JDEException ex) {
                Debug.printIf(ex);
                this.signalCommandError(cmd_id, ex);
                Object var8_6 = null;
                Collection collection3 = this.pendingCommands;
                synchronized (collection3) {
                    this.pendingCommands.remove(cmd_id);
                    return;
                }
            }
            catch (Exception ex) {
                Debug.printIf(ex);
                this.signalCommandError(cmd_id, "An unspecified error occured: '" + ex.toString() + "'");
                Object var8_7 = null;
                Collection collection4 = this.pendingCommands;
                synchronized (collection4) {
                    this.pendingCommands.remove(cmd_id);
                    return;
                }
            }
            Object var8_5 = null;
            collection = this.pendingCommands;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            Collection collection4 = this.pendingCommands;
            synchronized (collection4) {
                this.pendingCommands.remove(cmd_id);
                throw throwable;
            }
        }
        synchronized (collection) {
            this.pendingCommands.remove(cmd_id);
            return;
        }
    }

    public void resolve(ReferenceType ref) {
        this.eventRequestSpecs.resolve(ref);
    }

    public void informJDEInstallSuccessful(EventRequestSpec spec) {
        this.signal("spec-resolved", spec.getID());
    }

    public void removeSpecAndInformJDE(EventRequestSpec spec, String problem) {
        if (spec instanceof BreakpointSpec) {
            this.signal("invalid-break", new LispForm(spec.getID() + " \"" + problem + "\""));
        } else if (spec instanceof WatchpointSpec) {
            this.signal("invalid-watch", new LispForm(spec.getID() + " \"" + problem + "\""));
        } else if (spec instanceof ExceptionSpec) {
            this.signal("invalid-trace_exceptions", new LispForm(spec.getID() + " \"" + problem + "\""));
        }
        this.eventRequestSpecs.delete(spec);
    }

    public void signal(String type, Object obj) {
        this.jdebug.signal(this.appID, type, obj);
    }

    public void signalCommandResult(Integer cmd_id) {
        this.jdebug.signalCommandResult(this.appID, cmd_id);
    }

    public void signalCommandResult(Integer cmdID, Object obj) {
        this.jdebug.signalCommandResult(this.appID, cmdID, obj);
    }

    public void signalCommandError(Integer cmdID, String error) {
        this.jdebug.signalCommandError(this.appID, cmdID, error);
    }

    public void signalCommandError(Integer cmdID, JDEException ex) {
        this.jdebug.signalCommandError(this.appID, cmdID, ex.getMessage());
    }

    private boolean isShuttingDown() {
        return this.shuttingDown;
    }

    private class StandardErrorProcessor
    extends Thread {
        BufferedReader fromVM;

        public StandardErrorProcessor(InputStream fromVMStream) {
            super("Standard Error Processor for App #" + Application.this.appID);
            this.fromVM = new BufferedReader(new InputStreamReader(fromVMStream));
            this.setPriority(9);
        }

        /*
         * WARNING - void declaration
         */
        public void run() {
            try {
                String line;
                while ((line = this.fromVM.readLine()) != null) {
                    StandardOutputWriter standardOutputWriter = Application.this.standardOutputWriter;
                    synchronized (standardOutputWriter) {
                        if (Application.this.standardOutputWriter != null) {
                            void var1_1;
                            Application.this.standardOutputWriter.write((String)var1_1);
                        }
                    }
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            if (!Application.this.isShuttingDown()) {
                try {
                    Application.this.signal("message", "Closed transport for application's standard error output.");
                }
                catch (Exception ex) {
                    Application.this.signal("error", "Could not close application standard error output transport.");
                }
            }
        }
    }

    private class StandardOutputProcessor
    extends Thread {
        BufferedReader fromVM;

        public StandardOutputProcessor(InputStream fromVMStream) {
            this.fromVM = new BufferedReader(new InputStreamReader(fromVMStream));
            this.setPriority(9);
        }

        /*
         * WARNING - void declaration
         */
        public void run() {
            try {
                String line;
                while ((line = this.fromVM.readLine()) != null) {
                    StandardOutputWriter standardOutputWriter = Application.this.standardOutputWriter;
                    synchronized (standardOutputWriter) {
                        if (Application.this.standardOutputWriter != null) {
                            void var1_1;
                            Application.this.standardOutputWriter.write((String)var1_1);
                        }
                    }
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            if (!Application.this.isShuttingDown()) {
                try {
                    Application.this.signal("message", "Closed transport for application's standard output.");
                }
                catch (Exception ex) {
                    Application.this.signal("error", "Could not close application standard output transport.");
                }
            }
        }
    }

    private class StandardOutputWriter {
        PrintStream toEmacs;

        public StandardOutputWriter(Socket sioSocket) {
            OutputStream toEmacsStream;
            if (sioSocket == null) {
                Application.this.signal("error", "Could not transport app output. Transport socket does not exist.");
                return;
            }
            try {
                toEmacsStream = sioSocket.getOutputStream();
                if (toEmacsStream == null) {
                    Application.this.signal("error", "Could not transport app output. Transport socket closed.");
                    return;
                }
            }
            catch (IOException ex1) {
                Application.this.signal("error", "Could not transport app output. Transport socket closed.");
                return;
            }
            this.toEmacs = new PrintStream(toEmacsStream);
        }

        public void write(String line) {
            if (this.toEmacs != null) {
                this.toEmacs.println(line);
                this.toEmacs.flush();
            }
        }
    }

    private class StandardInputProcessor
    extends Thread {
        PrintStream toVM;
        BufferedReader fromEmacs;

        public StandardInputProcessor(OutputStream toVmStream) {
            super("Input Processor for App #" + Application.this.appID);
            this.toVM = new PrintStream(toVmStream, true);
            try {
                this.fromEmacs = new BufferedReader(new InputStreamReader(Application.this.sioSocket.getInputStream()));
            }
            catch (IOException ex1) {
                Application.this.signal("error", "Could not get standard input stream from Emacs.");
            }
            this.setPriority(9);
        }

        /*
         * WARNING - void declaration
         */
        public void run() {
            block9: {
                if (this.fromEmacs == null) {
                    return;
                }
                try {
                    String line;
                    while ((line = this.fromEmacs.readLine()) != null) {
                        void var1_1;
                        this.toVM.println((String)var1_1);
                        this.toVM.flush();
                    }
                    if (!Application.this.isShuttingDown()) {
                        try {
                            Application.this.signal("message", "Application closed its standard input.");
                        }
                        catch (Exception ex) {
                            Application.this.signal("message", "Couldn't close socket to standard input.");
                        }
                    }
                }
                catch (IOException ex) {
                    if (Application.this.isShuttingDown()) break block9;
                    try {
                        Application.this.signal("error", "Input error; application I/O closed");
                    }
                    catch (Exception e) {
                        Application.this.signal("error", "Input error; couldn't close application I/O");
                    }
                }
            }
        }
    }
}

